//
//  DHDSACNPacket.h
//  DHDMX
//
//  Created by Douglas Heriot on 9/04/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "DHDMXPacket.h"

@class DHDSACNIdentity;

@interface DHDSACNPacket : DHDMXPacket
@property (readonly, nonatomic) DHDSACNIdentity *identity;
@property (readonly, nonatomic) BOOL draft;
@property (readonly, nonatomic) uint16_t universe;
@property (readonly, nonatomic) NSData *CID;
@property (readonly, nonatomic) BOOL preview;
@property (readonly, nonatomic) BOOL streamTerminated;
@property (readonly, nonatomic) NSString *sourceName;
@property (readonly, nonatomic) uint8_t priority;
@property (readonly, nonatomic) uint8_t startCode;
@property (readonly, nonatomic) NSUInteger DMXLength;
@property (readonly, nonatomic) NSData *DMX;

- (id)initWithDMX:(NSData *)DMX identity:(DHDSACNIdentity *)identity prioritiy:(uint8_t)priority sequence:(uint8_t)sequence  sourceName:(NSString *)sourceName startCode:(uint8_t)startCode;

+ (BOOL)validatePacketData:(NSData *)data;

@end
